#include "commit_helpers.h"

#include "controller_helpers.h"

namespace maps::wiki::tests {

GeoObject::State
getObjectState(
    TOid objectId,
    TUid uid = TESTS_USER,
    TBranchId branchId = revision::TRUNK_BRANCH_ID)
{
    const auto getObjectResult =
        performRequest<GetObject>(
            objectId,
            uid,
            TESTS_TOKEN,
            branchId,
            GetObject::SubstitutionPolicy::Deny,
            GetObject::PartsOfComplexContourObjectsLoadPolicy::Load
        );

    return getObjectResult->collection.getById(objectId)->state();
}

} // namespace maps::wiki::tests
