#include "printers.h"

#include <maps/wikimap/mapspro/services/editor/src/approve_status.h>
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/objects/object.h>

#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/common/string_utils.h>

#include <sstream>


using namespace maps::wiki;

template <>
void Out<TCommitIds>(IOutputStream& os, const TCommitIds& commitIds)
{
    os << "TCommitIds{" << common::join(commitIds, ", ") << "}";
}


template <>
void Out<approve_status::ApproveStatus>(IOutputStream& os, approve_status::ApproveStatus approveStatus)
{
    std::ostringstream oss;
    oss << approveStatus;
    os << oss.str();
}


template <>
void Out<GeoObject::State>(IOutputStream& os, GeoObject::State state)
{
    switch (state) {
        case GeoObject::State::Draft:   os << "draft";   return;
        case GeoObject::State::Deleted: os << "deleted"; return;
    }
    throw maps::LogicError()
        << "Unsupported state: "
        << static_cast<std::underlying_type_t<GeoObject::State>>(state);
}
