#pragma once

#include <util/stream/output.h>

#include <ostream>
#include <tuple>
#include <utility>

namespace maps::wiki::tests {

namespace impl {

template <typename Tuple, size_t... index>
void printTuple(IOutputStream& os, const Tuple& tuple, std::index_sequence<index...>)
{
    (
        (os << (index != 0 ? ", " : "") << std::get<index>(tuple)),
        ...
    );
}

} // impl


template <typename... Args>
IOutputStream& operator<<(IOutputStream& os, const std::tuple<Args...>& tuple)
{
    os << "(";
    impl::printTuple(os, tuple, std::index_sequence_for<Args...>());
    os << ")";
    return os;
}

} // namespace maps::wiki::tests
