#include "tests_common.h"

#include "helpers.h"

#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <maps/libs/common/include/file_utils.h>

#include <boost/algorithm/string/predicate.hpp>
#include <boost/algorithm/string/replace.hpp>
#include <boost/filesystem.hpp>

#include <library/cpp/testing/unittest/env.h>
#include <string>

namespace maps::wiki::tests {

namespace {
const std::string SERVICES_BASE_TEMPLATE = "/maps/wikimap/mapspro/cfg/services/services-base-template.xml";
const std::string CATEGORIES_DIR_PATH = "/maps/wikimap/mapspro/cfg/editor";
const std::string RENDERER_MAP_XML_DIR_PATH = "/maps/wikimap/mapspro/cfg/layers/mpskl";
const std::string RENDERER_LAYERS_PATH = "/maps/wikimap/mapspro/cfg/layers";

namespace fs = boost::filesystem;

std::string
createTempServicesBaseXml()
{
    try {
        auto servicesBaseTemplate = maps::common::readFileToString(ArcadiaSourceRoot() + SERVICES_BASE_TEMPLATE);
        boost::replace_all(servicesBaseTemplate, "#CATEGORIES_DIR_PATH#", ArcadiaSourceRoot() + CATEGORIES_DIR_PATH);
        boost::replace_all(servicesBaseTemplate, "#RENDERER_MAP_XML_DIR_PATH#", ArcadiaSourceRoot() + RENDERER_MAP_XML_DIR_PATH);
        boost::replace_all(servicesBaseTemplate, "#RENDERER_LAYERS_PATH#", ArcadiaSourceRoot() + RENDERER_LAYERS_PATH);
        auto filepath = fs::temp_directory_path() / fs::unique_path();
        std::ofstream file(filepath.string());
        file << servicesBaseTemplate;
        return filepath.string();
    } catch (const std::exception& ex) {
        WARN() << ex.what();
    }
    return {};
}

void
createTestUser(pqxx::connection& conn)
{
    pqxx::work work(conn);
    work.exec(loadFile("tests/sql/create_test_user.sql"));
    work.commit();
}
}//namespace

EditorTestFixture::EditorTestFixture()
    : db()
    , configFile(db.database(), "",
            createTempServicesBaseXml())
    , cfgScope(configFile.filepath(), CONFIG_SERVICE_NAME, CONFIG_POOL_NAME)
{
    pqxx::connection conn(db.connectionString());
    log8::setLevel(log8::Level::FATAL);
    createTestUser(conn);
    cfg()->onLoad();
    initJsonSchemas();
}

void
EditorTestFixture::executeSqlFile(const std::string& fileName)
{
    pqxx::connection conn(db.connectionString());
    pqxx::work work(conn);
    work.exec(loadFile(fileName));
    work.commit();
}

} // namespace maps::wiki::tests
