#pragma once

#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/unittest/arcadia.h>
#include <yandex/maps/wiki/unittest/config.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <string>

namespace maps::wiki::tests {

const std::string CONFIG_SERVICE_NAME = "core";
const std::string CONFIG_POOL_NAME    = "editor";
const std::string TESTS_TOKEN         = "tests-token";

const TUid TESTS_USER  = 7777777;
const TUid TESTS_USER2 = 7777778;
const std::string USER_CREATED_OR_UNBANNED_TIME = "2010-10-10 10:10:10";

#define WIKI_TEST_REQUIRE(A) if (A) {} else {UNIT_FAIL("#A");}
#define WIKI_TEST_REQUIRE_EQUAL(A, B) if ((A) == (B)) {} else {UNIT_FAIL("#A not equal #B");}
#define WIKI_TEST_REQUIRE_MESSAGE(A, M) if (A) {} else { std::stringstream s; s << M; UNIT_FAIL(s.str());}
#define WIKI_TEST_ASSERT_MESSAGE(A, M) if (A) {} else { std::stringstream s; s << M; UNIT_ASSERT_C(false, s.str());}

#define WIKI_TEST_EQUAL_COLLECTIONS(LB, LE, RB, RE) \
do {\
    auto l = LB;\
    auto r = RB;\
    while ( l != LE && r != RE) {\
        UNIT_ASSERT_EQUAL(*l, *r);\
        ++l;\
        ++r;\
    }\
    UNIT_ASSERT(l == LE); \
} while(0)

struct SetLogLevelFixture
{
    SetLogLevelFixture()
    {
        log8::setLevel(log8::Level::FATAL);
    }
};

class EditorTestFixture {
public:
    EditorTestFixture();
    SetLogLevelFixture logLevel;

    unittest::ArcadiaDbFixture db;
    unittest::ConfigFileHolder configFile;
    ConfigScope cfgScope;
    void executeSqlFile(const std::string& fileName);
};

} // namespace maps::wiki::tests
