#include <maps/wikimap/mapspro/services/editor/src/geom.h>
#include <maps/wikimap/mapspro/services/editor/src/utils.h>

#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/tests_common.h>

namespace maps::wiki::tests {

Y_UNIT_TEST_SUITE(json_geom)
{
WIKI_FIXTURE_TEST_CASE(test_json_geom_utils, EditorTestFixture)
{
    common::Geom g(createGeomFromJsonStr(loadFile("tests/data/polygon.json")));
    UNIT_ASSERT(g->getGeometryTypeId()
        == geos::geom::GEOS_POLYGON);
    auto pointJSON = loadFile("tests/data/point.json");
    UNIT_ASSERT_NO_EXCEPTION(createGeoPointFromJsonStr(pointJSON));
    UNIT_ASSERT_NO_EXCEPTION(createGeoPointCollectionFromJsonStr(
        loadFile("tests/data/point_coll.json")));
}

Y_UNIT_TEST(fix_ring)
{
    std::vector<geos::geom::Coordinate> coords1 {{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}};
    std::vector<geos::geom::Coordinate> coords2 {{0, 0}, {0.999999, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}};
    std::vector<geos::geom::Coordinate> coords3 {{0, 0}, {0, 2}, {0.000001, 1}, {1, 2}, {1, 0}, {0, 0}};
    std::vector<geos::geom::Coordinate> coords4 {{-2, -1}, {-2, 0.0000001}, {1, 0.0000001}, {1, 1}, {2, 1}, {2, -0.0000001}, {-1, -0.0000001}, {-1, -1}, {-2, -1}};

    tryFixRing(coords1);
    tryFixRing(coords2);
    tryFixRing(coords3);
    UNIT_CHECK_GENERATED_EXCEPTION(tryFixRing(coords4), LogicException);

    std::vector<geos::geom::Coordinate> result1 = {{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}};
    std::vector<geos::geom::Coordinate> result2 = {{0, 0}, {0.999999, 0}, {1, 1}, {0, 1}, {0, 0}};
    std::vector<geos::geom::Coordinate> result3 = {{0, 0}, {0.000001, 1}, {1, 2}, {1, 0}, {0, 0}};

    UNIT_ASSERT(coords1 == result1);
    UNIT_ASSERT(coords2 == result2);
    UNIT_ASSERT(coords3 == result3);

}
} //Y_UNIT_TEST_SUITE

} // namespace maps::wiki::tests
