#include <maps/wikimap/mapspro/services/editor/src/edit_options.h>
#include <maps/wikimap/mapspro/services/editor/src/topologycal.h>
#include <maps/wikimap/mapspro/services/editor/src/utils.h>

#include <yandex/maps/wiki/configs/editor/unique_list.h>

#include <library/cpp/testing/unittest/registar.h>
#include <geos/io/WKTReader.h>

namespace maps::wiki::tests {

Y_UNIT_TEST_SUITE(simple_tests)
{

Y_UNIT_TEST(test_topologycal_sort)
{
    int objects[]={10, 13, 15, 12, 11, 14};
    int objectsWithGap[]={21, 13, 15, 12, 11, 14};
    size_t objectsCount = sizeof(objects)/sizeof(int);
    auto result1 = topologycalOrder(&objects[0],
        objects + objectsCount,
        [](int a, int b){
            //Integers a and b considered touching
            //if they are same or abs(a-b)=1
            return (a-b)*(a-b) < 2;
        }
    );
    UNIT_ASSERT(result1.size() == objectsCount);
    auto result2 = topologycalOrder(&objectsWithGap[0],
        objectsWithGap + objectsCount,
        [](int a, int b){
            return (a-b)*(a-b) < 2;
        }
    );
    UNIT_ASSERT(result2.empty());
}

Y_UNIT_TEST(test_unique_container)
{

    const int testInArray[]={9,1,3,5,7,3,9,2,7};
    const int testOutArray[]={9,1,3,5,7,2};
    UniqueList<int> container1;
    do
    {
        UniqueList<int> container;
        for(auto a: testInArray){
            container.push_back(a);
        }
        UNIT_ASSERT_EQUAL(container.size(), 6);
        UNIT_ASSERT(container.find(9) == container.begin());
        size_t i = 0;
        for(auto j : container){
            UNIT_ASSERT_EQUAL(j, testOutArray[i++]);
        }
        UNIT_ASSERT(container.find(2) != container.end());
        container.remove(2);
        UNIT_ASSERT_EQUAL(container.size(), 5);
        UNIT_ASSERT(container.find(2) == container.end());
        container.removeIf([](int c){return (c%3)==0;});
        UNIT_ASSERT_EQUAL(container.size(), 3);
        container1.swap(container);
        UNIT_ASSERT(container.empty());
    }while(0);
    UNIT_ASSERT_EQUAL(container1.size(), 3);
    UNIT_ASSERT(container1.find(1) == container1.begin());
    UNIT_ASSERT_EQUAL(1, *(container1.find(1)));

}

Y_UNIT_TEST(test_envelope)
{
    //! Check that geos::envelope accepts
    //! coordinates in order X1,X2,Y1,Y2
    const std::string coordsString = "3,2,1,4";
    const std::string resultString = "1234";
    auto envelope =
        createEnvelope(
                coordsString,
                common::SpatialRefSystem::Mercator);
    std::stringstream output;
    output.precision(0);
    output << envelope.getMinX() << envelope.getMinY()
        << envelope.getMaxX() << envelope.getMaxY();
    UNIT_ASSERT_EQUAL(resultString, output.str());
}

Y_UNIT_TEST(test_geom_buffer)
{
//THIS TESTCASE SHOULD NOT CALL ABORT
//CAUSED BY GEOS ASSERT CALL
//[[4,145],[14,155],[8,155],[1,142],[4,145]]
    const geolib3::Polyline2 LINESTRING(
    geolib3::PointsVector {
        geolib3::Point2(4.0, 145.0),
        geolib3::Point2(14.0, 155.0),
        geolib3::Point2(8.0, 155.0),
        geolib3::Point2(1.0, 142.0),
        geolib3::Point2(4.0, 145.0),
    } );
    Geom g = polylineToGeom(LINESTRING);
    UNIT_ASSERT_NO_EXCEPTION(g.createBuffer(5.0));
}

Y_UNIT_TEST(test_geos_buffer_segfault)
{
    //This test produces segfault on not patched version of geos
    //due to precision loss in geos::algorithm::RobustDeterminant::signOfDet2x2
    //for collinear vector
    geos::io::WKTReader reader;

    common::Geom line(reader.read(
        "LINESTRING(-25.000000000000 100.000000000000, "
        "29.000000000000 244.000000000000, 69.000000000000 229.000000000000,"
        " 15.000000000000 85.000000000000, -25.000000000000 100.000000000000)"));
    auto buffer = line.createBuffer(10);
    UNIT_ASSERT_EQUAL(buffer->getGeometryTypeId(), geos::geom::GEOS_POLYGON);
    UNIT_ASSERT(buffer->contains(line.geosGeometryPtr()));
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::wiki::tests
