#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/serialize/save_object_parser.h>

#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/controller_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/tests_common.h>

#include <yandex/maps/wiki/configs/editor/exception.h>

namespace maps::wiki::tests {

Y_UNIT_TEST_SUITE(parser_required_pair_attr)
{
WIKI_FIXTURE_TEST_CASE(test_parser_required_pair, EditorTestFixture)
{
    auto parser = SaveObjectParser();
    UNIT_CHECK_GENERATED_EXCEPTION(
        parser.parse(
            common::FormatType::XML,
            loadFile("tests/data/cond_missing_required_pair_attr.xml")),
        configs::editor::WrongAttributeValueError);
    UNIT_ASSERT_NO_EXCEPTION(
        parser.parse(
            common::FormatType::XML,
            loadFile("tests/data/cond_complete_required_pair_attr.xml")));
}
}//Y_UNIT_TEST_SUITE

} // namespace maps::wiki::tests
