#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/actions/save_object.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/commit_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/controller_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/objects_creator/objects_creator.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/task_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/extended_editor_fixture.h>

#include <maps/wikimap/mapspro/services/editor/src/observers/social.h>
#include <maps/wikimap/mapspro/services/editor/src/observers/view_syncronizer.h>

#include <yandex/maps/wiki/common/robot.h>

#include <library/cpp/testing/unittest/registar.h>


namespace maps::wiki::tests {

using DbWithAoi = ExtendedEditorFixture<ViewSyncronizer, SocialObserver>;


Y_UNIT_TEST_SUITE(resolve)
{
    WIKI_FIXTURE_TEST_CASE_P(
        should_close_depending_commits_for_autoapprove_category, DbWithAoi, TRUSTED_USERS)
    {
        const auto aoiCreate = saveObject(user, aoi(), observers);
        const auto aoiEdit1 = saveObject(
            user,
            aoi().revisionId(aoiCreate.revisionId).attr("aoi:name", "name 1"),
            observers);
        const auto aoiEdit2 = saveObject(
            user,
            aoi().revisionId(aoiEdit1.revisionId).attr("aoi:name", "name 2"),
            observers);

        const auto userType = getParam();
        const auto user = userTypeToUid.at(userType);
        resolveCommitTask(user, aoiEdit1.commitId, social::ResolveResolution::Accept);
        switch (userType) {
            case UserType::Moderator:
                WIKI_ASSERT_COMMIT_STATE(aoiCreate.commitId, DRAFT, Approved);
                break;
            case UserType::Cartographer:
                WIKI_ASSERT_COMMIT_STATE(aoiCreate.commitId, PREAPPROVING, Approved);
                break;
            default: UNIT_ASSERT(false);
        }
        WIKI_ASSERT_COMMIT_STATE(aoiEdit1.commitId, PREAPPROVING, Approved);
        WIKI_ASSERT_COMMIT_STATE(aoiEdit2.commitId, DRAFT, Pending);

        WIKI_ASSERT_COMMIT_TASK_CLOSED(aoiCreate.commitId, common::ROBOT_UID, Accept, common::ROBOT_UID, Approve);
        WIKI_ASSERT_COMMIT_TASK_CLOSED(aoiEdit1.commitId, user, Accept, common::ROBOT_UID, Approve);
        WIKI_ASSERT_COMMIT_TASK_UNRESOLVED(aoiEdit2.commitId);
    }

    WIKI_FIXTURE_TEST_CASE_P(
        should_resolve_or_close_depending_commits_for_non_autoapprove_category, DbWithAoi, TRUSTED_USERS)
    {
        const auto poiCreate = saveObject(user, poiFood(), observers);
        const auto poiEdit1 = saveObject(
            user,
            poiFood().revisionId(poiCreate.revisionId).attr("poi_food:disp_class", "10"),
            observers);
        const auto poiEdit2 = saveObject(
            user,
            poiFood().revisionId(poiEdit1.revisionId).attr("poi_food:disp_class", "5"),
            observers);

        const auto userType = getParam();
        const auto user = userTypeToUid.at(userType);
        resolveCommitTask(user, poiEdit1.commitId, social::ResolveResolution::Accept);
        switch (userType) {
            case UserType::Moderator:
                WIKI_ASSERT_COMMIT_STATE(poiCreate.commitId, DRAFT, Pending);
                WIKI_ASSERT_COMMIT_STATE(poiEdit1.commitId, DRAFT, Pending);
                WIKI_ASSERT_COMMIT_TASK_RESOLVED(poiCreate.commitId, common::ROBOT_UID, Accept);
                WIKI_ASSERT_COMMIT_TASK_RESOLVED(poiEdit1.commitId, user, Accept);
                break;
            case UserType::Cartographer:
                WIKI_ASSERT_COMMIT_STATE(poiCreate.commitId, PREAPPROVING, Approved);
                WIKI_ASSERT_COMMIT_STATE(poiEdit1.commitId, PREAPPROVING, Approved);
                WIKI_ASSERT_COMMIT_TASK_CLOSED(poiCreate.commitId, common::ROBOT_UID, Accept, common::ROBOT_UID, Approve);
                WIKI_ASSERT_COMMIT_TASK_CLOSED(poiEdit1.commitId, user, Accept, common::ROBOT_UID, Approve);
                break;
            default: UNIT_ASSERT(false);
        }

        WIKI_ASSERT_COMMIT_STATE(poiEdit2.commitId, DRAFT, Pending);
        WIKI_ASSERT_COMMIT_TASK_UNRESOLVED(poiEdit2.commitId);
    }

    WIKI_FIXTURE_TEST_CASE(
        should_resolve_depending_commits_before_moderator_edit_with_edit_resolution, DbWithAoi)
    {
        const auto poiCreate = saveObject(user, poiFood(), observers);
        const auto poiUserEdit1 = saveObject(
            user,
            poiFood().revisionId(poiCreate.revisionId).attr("poi_food:disp_class", "1"),
            observers);
        const auto poiModEdit = saveObject(
            moderator,
            poiFood().revisionId(poiUserEdit1.revisionId).attr("poi_food:disp_class", "2"),
            observers);
        const auto poiUserEdit2 = saveObject(
            user,
            poiFood().revisionId(poiModEdit.revisionId).attr("poi_food:disp_class", "3"),
            observers);

        resolveCommitTask(moderator, poiUserEdit2.commitId, social::ResolveResolution::Accept);

        WIKI_ASSERT_COMMIT_STATE(poiCreate.commitId, DRAFT, Pending);
        WIKI_ASSERT_COMMIT_STATE(poiUserEdit1.commitId, DRAFT, Pending);
        WIKI_ASSERT_COMMIT_STATE(poiModEdit.commitId, DRAFT, Pending);
        WIKI_ASSERT_COMMIT_STATE(poiUserEdit2.commitId, DRAFT, Pending);

        WIKI_ASSERT_COMMIT_TASK_RESOLVED(poiCreate.commitId, common::ROBOT_UID, Edit);
        WIKI_ASSERT_COMMIT_TASK_RESOLVED(poiUserEdit1.commitId, common::ROBOT_UID, Edit);
        WIKI_ASSERT_COMMIT_TASK_RESOLVED(poiModEdit.commitId, common::ROBOT_UID, Accept);
        WIKI_ASSERT_COMMIT_TASK_RESOLVED(poiUserEdit2.commitId, moderator, Accept);
    }
}

} // namespace maps::wiki::tests
