#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/actions/save_object.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/commit_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/objects_creator/objects_creator.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/task_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/extended_editor_fixture.h>

#include <maps/wikimap/mapspro/services/editor/src/observers/social.h>
#include <maps/wikimap/mapspro/services/editor/src/observers/view_syncronizer.h>

#include <library/cpp/testing/unittest/registar.h>


namespace maps::wiki::tests {

using Fixture = ExtendedEditorFixture<ViewSyncronizer, SocialObserver>;


Y_UNIT_TEST_SUITE(save)
{
    WIKI_FIXTURE_TEST_CASE_P(
        should_not_approve_depending_commits_on_save_for_autoapprove_category, Fixture,
        TRUSTED_USERS)
    {
        const auto trustedUser = userTypeToUid.at(getParam());

        const auto aoiCreate = saveObject(user, aoi(), observers);
        const auto aoiEdit = saveObject(
            trustedUser,
            aoi().revisionId(aoiCreate.revisionId).attr("aoi:name", "name"),
            observers);

        WIKI_ASSERT_COMMIT_STATE(aoiCreate.commitId, DRAFT, Pending);
        WIKI_ASSERT_COMMIT_STATE(aoiEdit.commitId, PREAPPROVING, Approved);

        WIKI_ASSERT_COMMIT_TASK_UNRESOLVED(aoiCreate.commitId);
        WIKI_ASSERT_COMMIT_HAS_NO_TASK(aoiEdit.commitId);
    }
}

} // namespace maps::wiki::tests
