#include <maps/wikimap/mapspro/services/editor/src/background_tasks/suspicious_users_table_cleaner.h>

#include <maps/wikimap/mapspro/services/editor/src/tests/helpers/tests_common.h>

#include <yandex/maps/wiki/unittest/localdb.h>
#include <yandex/maps/wiki/unittest/query_helpers.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>

#include <cstdint>
#include <string>
#include <thread>

namespace maps::wiki::tests {

using namespace testing;

struct Fixture: public NUnitTest::TBaseFixture, public EditorTestFixture {
    pqxx::connection conn;
    const std::string SCHEMA = "social";
    unittest::QueryHelpers queryHelpers;

    Fixture()
        : conn(db.connectionString())
        , queryHelpers(conn)
    {}

    void applyQuery(const std::string& query) {
        queryHelpers.applyQueryToSchema(SCHEMA, query);
    }

    std::vector<uint64_t> getSuspiciousUsersIds() {
        auto rows = queryHelpers.applyQueryToSchema(
            SCHEMA,
            "SELECT uid FROM suspicious_users"
        );

        std::vector<uint64_t> result;
        result.reserve(rows.size());
        for (const auto& row: rows) {
            result.push_back(row[0].as<uint64_t>());
        }
        return result;
    }
};

Y_UNIT_TEST_SUITE_F(suspicious_users, Fixture)
{
    Y_UNIT_TEST(shouldRemoveOldUsersPeriodically)
    {
        using namespace std::literals::chrono_literals;

        applyQuery(
            "INSERT INTO suspicious_users VALUES "
            "(1, NOW() - interval '2 weeks' - interval '1 sec'),"
            "(2, NOW() - interval '2 weeks' + interval '1 sec'),"
            "(3, NOW() - interval '2 weeks' + interval '2 sec')"
        );

        SuspiciousUsersTableCleaner cleaner(cfg()->poolSocial(), std::chrono::seconds(1));
        std::this_thread::sleep_for(400ms);
        EXPECT_THAT(getSuspiciousUsersIds(), ElementsAre(2, 3));

        std::this_thread::sleep_for(1s);
        EXPECT_THAT(getSuspiciousUsersIds(), ElementsAre(3));

        std::this_thread::sleep_for(1s);
        EXPECT_THAT(getSuspiciousUsersIds(), ElementsAre());
    }
}

} // namespace maps::wiki::tests
