#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/execution_state.h>
#include <maps/wikimap/mapspro/services/editor/src/sync/db_helpers.h>

#include <yandex/maps/wiki/revision/branch.h>

namespace maps::wiki::tool {

class StableBranchBuilder
{
public:
    explicit StableBranchBuilder(
        const ExecutionStatePtr& executionState,
        TUid uid,
        size_t threads);

    void run() const;

private:
    revision::Branch syncApprovedAndPrepareStableBranch(
        revision::Branch& approvedBranch,
        size_t threads) const;

    revision::Branch prepareStableBranch(
        const revision::Branch& approvedBranch,
        const sync::BranchLocker& branchLocker) const;

    ExecutionStatePtr executionState_;
    TUid uid_;
    size_t threads_;
};

} // namespace maps::wiki::tool
