#include "delete_linear_element_callback.h"

#include <maps/wikimap/mapspro/services/editor/src/collection.h>
#include <maps/wikimap/mapspro/services/editor/src/objects/linear_element.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>
#include <maps/wikimap/mapspro/services/editor/src/objects/relation_object.h>
#include <maps/wikimap/mapspro/services/editor/src/relations_processor.h>
#include "topo_relations_processor.h"

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {

DeleteLinearElementCallback::DeleteLinearElementCallback(
        ObjectsCache& cache,
        topo::Cache&)
    : cache_(cache)
{}

void
DeleteLinearElementCallback::processRequest(topo::DeleteEdgeRequest& /*request*/) const
{}

void
DeleteLinearElementCallback::processEvent(const topo::DeleteEdgeEvent& event) const
{
    LinearElement* deleted = as<LinearElement>(cache_.getExisting(event.id()));

    RelationsProcessor processor(cache_);

    processor.deleteRelations(RelationType::Master, deleted);
}

} // namespace maps
} // namespace wiki
