#pragma once

#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>
#include <maps/wikimap/mapspro/services/editor/src/relations_processor.h>

#include <yandex/maps/wiki/topo/editor.h>
#include <yandex/maps/wiki/topo/events.h>

namespace maps {
namespace wiki {

enum class MergeJunctionsPolicy { Allow, Restrict };

class RestrictedMergeJunctionsCallback : public topo::MergeNodesCallback
{
public:

    virtual void processRequest(topo::MergeNodesRequest& request) const
    {
        THROW_WIKI_LOGIC_ERROR(ERR_TOPO_JC_OVERLAP,
            "Moving junction "  << request.deletedId() <<
            " over other junction " << request.mergedId());
    }

    virtual void processEvent(const topo::MergeNodesEvent& event) const
    {
        THROW_WIKI_LOGIC_ERROR(ERR_TOPO_JC_OVERLAP,
            "Moving junction "  << event.deletedId() <<
            " over other junction " << event.mergedId());
    }
};

class AllowedMergeJunctionsCallback : public topo::MergeNodesCallback
{
public:

    AllowedMergeJunctionsCallback(ObjectsCache& cache)
        : cache_(cache)
    {}

    virtual void processEvent(const topo::MergeNodesEvent& event) const
    {
        auto deletedJc = cache_.getExisting(event.deletedId());
        auto mergedJc = cache_.getExisting(event.mergedId());

        RelationsProcessor processor(cache_);

        processor.replaceWithMerged(RelationType::Master, deletedJc.get(), mergedJc.get());
    }

private:
    ObjectsCache& cache_;
};

} // namespace wiki
} // namespace maps
