#pragma once

#include "topological_callbacks.h"

#include <yandex/maps/wiki/topo/editor.h>
#include <yandex/maps/wiki/topo/events.h>

namespace maps {
namespace wiki {

class GeoObjectCollection;
class ObjectsCache;

class SplitLinearElementCallback : public topo::SplitEdgeCallback
{
public:
    SplitLinearElementCallback(
            const NewLinearElementsDataMap& linearElementsData,
            ObjectsCache& cache)
        : linearElementsData_(linearElementsData)
        , cache_(cache)
    {}

    virtual void processRequest(topo::SplitEdgeRequest& request) const;
    virtual void processEvent(const topo::SplitEdgeEvent& event) const;

private:
    const NewLinearElementsDataMap& linearElementsData_;
    ObjectsCache& cache_;
};

} // namespace wiki
} // namespace maps
