#pragma once

#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include "topological_callbacks.h"

#include <maps/wikimap/mapspro/services/editor/src/object_update_data.h>
#include <maps/wikimap/mapspro/services/editor/src/serialize/topo_object_data.h>

namespace maps {
namespace wiki {

class ObjectsCache;

class TopoCache
{
public:
    TopoCache(
        const TopologyGroup& topoGroup,
        ObjectsCache& cache,
        geolib3::BoundingBox region);

    TOIds nodeIdsByBBox(const geolib3::BoundingBox& bbox) const;
    TOIds edgeIdsByBBox(const geolib3::BoundingBox& bbox) const;

    const geolib3::BoundingBox& region() const { return region_; }
    double tolerance() const { return tolerance_; }

    /// Only add new
    void addObject(TOid id);
    /// Only update existing
    void updateObject(TOid id, const Geom& newGeom);
    void deleteObject(TOid id);

private:
    void preload();

    TOIds idsByBBox(
        const geolib3::BoundingBox& bbox,
        const StringSet& categoryIds) const;

    const TopologyGroup& topoGroup_;
    const StringSet jcToLeRoles_;
    ObjectsCache& cache_;

    geolib3::BoundingBox region_;
    double tolerance_;

    struct CachedData
    {
        std::string categoryId;
        geolib3::BoundingBox bbox;
        bool deleted;
    };

    std::map<TOid, CachedData> cachedObjects_;
};

} // namespace wiki
} // namespace maps
