#pragma once

#include "topological_callbacks.h"
#include "topo_relations_processor.h"
#include "split_linear_element_callback.h"
#include "merge_junctions_callback.h"

#include <maps/wikimap/mapspro/services/editor/src/topo_storage.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

#include <yandex/maps/wiki/topo/editor.h>
#include <yandex/maps/wiki/topo/cache.h>
#include <yandex/maps/wiki/topo/common.h>

#include <memory>

namespace maps {
namespace wiki {

class TopologyEditContext
{
public:
    TopologyEditContext(
            const TopologyGroup& topoGroup,
            ObjectsCache& cache,
            NewLinearElementsDataMap& newLinearElementsData,
            MergeJunctionsPolicy mergeJunctionsPolicy = MergeJunctionsPolicy::Restrict);

    /// Recreate cache and editor using same storage
    void reset();

    const TopologyGroup& topoGroup() const { return topoGroup_; }
    ObjectsCache& cache() { return cache_; }
    TopoStorage& storage() { return *storage_; }
    topo::Cache& topoCache() { return *topoCache_; }
    topo::Editor& editor() { return *editor_; }
    NewLinearElementsDataMap& newLinearElementsData() { return newLinearElementsData_; }

    topo::TopologyRestrictions getRestrictions(TZoom zoom);

private:
    const TopologyGroup& topoGroup_;
    ObjectsCache& cache_;
    std::unique_ptr<TopoStorage> storage_;
    std::unique_ptr<topo::Cache> topoCache_;
    std::unique_ptr<topo::Editor> editor_;
    NewLinearElementsDataMap& newLinearElementsData_;
    MergeJunctionsPolicy mergeJunctionsPolicy_;
};

} // namespace wiki
} // namespace maps
