#pragma once

#include <maps/wikimap/mapspro/services/editor/src/relation_infos.h>

namespace maps {
namespace wiki {

class GeoObject;
class LinearElement;
class Junction;
class ObjectsCache;

class TopoRelationsProcessor
{
public:
    explicit TopoRelationsProcessor(ObjectsCache& cache);

    void addLinearElementToJunction(Junction *jc, LinearElement* le,
        const std::string& roleId);
    void removeLinearElementFromJunction(Junction *jc, LinearElement* le,
        const std::string& roleId);

    void updateSeqNums(GeoObject* obj);

private:
    void computeSeqNums(
        GeoObject* obj, const std::list<RelationInfo>& slavesWithGeom);

    ObjectsCache& cache_;
};

} // namespace wiki
} // namespace maps
