#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/object_update_data.h>

#include <yandex/maps/wiki/topo/events.h>
#include <yandex/maps/wiki/topo/editor.h>

namespace maps {
namespace wiki {

class ObjectsCache;

typedef std::map<std::string, TOIds> RelativeIdsByRoleMap;

// Assuming no slaves in LinearElements
struct NewLinearElementData
{
    const ObjectUpdateData* updateData;
    RelativeIdsByRoleMap mastersDiff;
    bool isPrimary;
};

typedef std::map<TOid, NewLinearElementData> NewLinearElementsDataMap;

class TopoAddLinearElementCallback : public topo::TopoAddEdgeCallback
{
public:
    TopoAddLinearElementCallback(
            const NewLinearElementsDataMap& linearElementsData,
            ObjectsCache& cache)
        : linearElementsData_(linearElementsData)
        , cache_(cache)
    {}

    virtual void process(const topo::AddEdgeEvent& event) const;

private:
    const NewLinearElementsDataMap& linearElementsData_;
    ObjectsCache& cache_;
};

class TopoMoveLinearElementCallback : public topo::TopoMoveEdgeCallback
{
public:
    explicit TopoMoveLinearElementCallback(ObjectsCache& cache)
        : cache_(cache)
    {}

    virtual void process(const topo::MoveEdgeEvent& event) const;

private:
    ObjectsCache& cache_;
};

class TopoDeleteLinearElementCallback : public topo::TopoDeleteEdgeCallback
{
public:
    explicit TopoDeleteLinearElementCallback(ObjectsCache& cache)
        : cache_(cache)
    {}

    virtual void process(const topo::DeleteEdgeEvent& event) const;

private:
    ObjectsCache& cache_;
};

} // namespace wiki
} // namespace maps
