#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <yandex/maps/wiki/social/common.h>

#include <memory>
#include <optional>

namespace maps::wiki {

class BranchContext;

class UserContext {
public:
    UserContext(
        TUid uid,
        std::string_view userRealIp,
        std::optional<uint16_t> = std::nullopt);

    TUid uid() const { return uid_; }

    const acl::User& aclUser(const BranchContext& branchContext);

    const std::string& moderationStatus(const BranchContext& branchContext);

    void saveActivity(
        const BranchContext& branchContext,
        social::UserActivityAction action,
        const std::optional<TId>& entityId) const;

private:
    struct CachedUserData {
        explicit CachedUserData(const BranchContext& branchContext)
            : branchContext(branchContext)
        {}

        const BranchContext& branchContext;
        std::optional<acl::User> user;
    };

    const TUid uid_;
    const std::string userRealIp_;
    const std::optional<uint16_t> port_;
    std::shared_ptr<CachedUserData> cachedUserData_;
    std::shared_ptr<std::string> cachedModerationStatus_;
};

} // namespace maps::wiki
