#pragma once
#include "objectvisitor.h"
#include "context.h"
#include "collection.h"
#include "objects/object.h"
#include "exception.h"

namespace maps {
namespace wiki {

class Validator : protected ObjectVisitor
{
public:
    Validator(
            TUid uid,
            ObjectsCache& cache,
            const GeoObjectCollection& modifiedObjects,
            const ObjectsEditContextsPtrMap& editContexts = ObjectsEditContextsPtrMap())
        : uid_(uid)
        , cache_(cache)
        , collection_(modifiedObjects)
        , editContexts_(editContexts)
    {
        collectObjects();
    }

    void validate();

private:
    virtual void visitGeoObject(const GeoObject* obj);
    virtual void visitArealObject(const ArealObject* obj);
    virtual void visitJunction(const Junction* obj);
    virtual void visitLinearElement(const LinearElement* obj);
    virtual void visitLineObject(const LineObject* obj);
    virtual void visitPointObject(const PointObject* obj);
    virtual void visitComplexObject(const ComplexObject* obj);
    virtual void visitAttrObject(const AttrObject* obj);
    virtual void visitRelationObject(const RelationObject* obj);

private:
    TUid uid_;
    ObjectsCache& cache_;
    GeoObjectCollection collection_;
    std::unordered_map<std::string, bool> ignoreRestrictionsCategories_;
    std::unordered_map<std::string, bool> overlayGroupCategories_;

    ObjectsEditContextsPtrMap editContexts_;

    bool allowInvalidContoursWithinContext(TOid oid) const;
    void collectObjects();

    void validateRelatedAttributes(const GeoObject* obj);
    void validateObjectMasterRelations(const GeoObject* obj);
    void validateParentRelations(const GeoObject* obj);
    void validateObjectSlaveRelations(const GeoObject* obj);
    void validateComplexObjectContents(const ComplexObject* obj);
    void validateComplexObjectTopology(const ComplexObject* obj);
    void validateObjectGeometry(const GeoObject* obj);
    void validateLineGeometry(const GeoObject* obj);
    void validatePolygonGeometry(const GeoObject* obj);
    void validateProhibitedObject(const GeoObject* obj);
    void validateObjectOverlay(const GeoObject* obj);

    bool allowToIgnoreRestrictions(const GeoObject* obj);
};

//required by service attributes computation routines
bool isComplexObjectTopologyValid(const ComplexObject* obj, ObjectsCache& cache);

} // namespace wiki
} // namespace maps
