#pragma once
#include "common.h"

namespace maps {
namespace wiki {

class View
{
public:
    View(TGeoPoint center, TZoom zoom)
        : center_(center)
        , zoom_(zoom)
    {}

    View()
        : center_(0,0)
        , zoom_(0)
    {}

    const TGeoPoint& center() const { return center_; }

    TZoom zoom() const { return zoom_; }

    void put(std::ostream& os) const;

private:
    TGeoPoint center_;
    TZoom zoom_;
};

} // namespace wiki
} // namespace maps
