#include "objects_a.h"
#include <maps/wikimap/mapspro/services/editor/src/sync/db_helpers.h>

#include <maps/wikimap/mapspro/libs/views/include/magic_strings.h>

namespace maps {
namespace wiki {
namespace views {

ArealViewObject::ArealViewObject(Transaction& work, const ArealObject* obj)
    : base_(work, obj)
    , area_(obj->area())
{
}

std::string ArealViewObject::valueStr() const
{
    std::ostringstream str;
    str.precision(DOUBLE_FORMAT_PRECISION);
    str << area_;
    return base_.valueStr() + "," + str.str();
}

std::string ArealViewObject::setStr() const
{
    std::ostringstream str;
    str.precision(DOUBLE_FORMAT_PRECISION);
    str << "area=" << area_;
    return base_.setStr() + "," + str.str();
}

const std::string ArealViewObject::tableName = TABLE_OBJECTS_A;
const std::string ArealViewObject::fields = "(id, commit_id, the_geom, zmin, zmax, domain_attrs, area)";
const std::string ArealViewObject::insertFunction = "vrevisions_stable.insert_areal";
const std::string ArealViewObject::updateFunction = "vrevisions_stable.update_areal";
const std::string ArealViewObject::updateSrvAttrsFunction = "vrevisions_stable.update_areal_service_attrs";
const std::string ArealViewObject::deleteFunction = "vrevisions_stable.delete_areal";

} // namespace views
} // namespace wiki
} // namespace maps
