#pragma once

#include "objects_base.h"
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/objects/areal_object.h>

namespace maps {
namespace wiki {
namespace views {

class ArealViewObject
{
public:
    ArealViewObject(Transaction& work, const ArealObject* obj);

    static const std::string tableName;
    static const std::string fields;
    static const std::string insertFunction;
    static const std::string updateFunction;
    static const std::string updateSrvAttrsFunction;
    static const std::string deleteFunction;

    TOid id() const { return base_.id; }

    std::string valueStr() const;
    std::string setStr() const;

private:
    ObjectBase base_;
    double area_;
};

} // namespace views
} // namespace wiki
} // namespace maps
