#include "objects_base.h"

#include <maps/wikimap/mapspro/services/editor/src/sync/db_helpers.h>

namespace maps {
namespace wiki {
namespace views {

ObjectBase::ObjectBase(Transaction& work, const GeoObject* obj)
    : id(obj->id())
    , commitId(obj->revision().commitId())
    , zmin(obj->zmin())
    , zmax(obj->zmax())
    , domainAttrs(obj->attributes().asHstore(work))
{
    theGeomStr = obj->geom().isNull()
        ? sync::STR_NULL
        : "ST_GeomFromWkb('" + work.esc_raw(obj->geom().wkb()) + "',3395)";
}

std::string ObjectBase::valueStr() const
{
    std::ostringstream str;
    str << id << ","
        << commitId << ","
        << theGeomStr << ","
        << zmin << ","
        << zmax << ","
        << domainAttrs;
    return str.str();
}

std::string ObjectBase::setStr() const
{
    std::ostringstream str;
    str << "commit_id=" << commitId << ","
        << "the_geom=" << theGeomStr << ","
        << "zmin=" << zmin << ","
        << "zmax=" << zmax << ","
        << "domain_attrs=" << domainAttrs;
    return str.str();
}

} // namespace views
} // namespace wiki
} // namespace maps
