#include "objects_c.h"

#include <maps/wikimap/mapspro/libs/views/include/magic_strings.h>

namespace maps {
namespace wiki {
namespace views {

ComplexViewObject::ComplexViewObject(Transaction& work, const GeoObject* obj)
    : base_(work, obj)
{
}

std::string ComplexViewObject::valueStr() const
{
    std::ostringstream str;
    str << base_.id << ","
        << base_.commitId << ","
        << base_.domainAttrs;
    return str.str();
}

std::string ComplexViewObject::setStr() const
{
    std::ostringstream str;
    str << "commit_id=" << base_.commitId << ","
        << "domain_attrs=" << base_.domainAttrs;
    return str.str();
}

const std::string ComplexViewObject::tableName = TABLE_OBJECTS_C;
const std::string ComplexViewObject::fields = "(id, commit_id, domain_attrs)";
const std::string ComplexViewObject::insertFunction = "vrevisions_stable.insert_complex";
const std::string ComplexViewObject::updateFunction = "vrevisions_stable.update_complex";
const std::string ComplexViewObject::updateSrvAttrsFunction = "vrevisions_stable.update_complex_service_attrs";
const std::string ComplexViewObject::deleteFunction = "vrevisions_stable.delete_complex";

} // namespace views
} // namespace wiki
} // namespace maps
