#include "objects_l.h"

#include <maps/wikimap/mapspro/libs/views/include/magic_strings.h>

namespace maps {
namespace wiki {
namespace views {

LinearViewObject::LinearViewObject(Transaction& work, const GeoObject* obj)
    : base_(work, obj)
    , length_(obj->geom().realLength())
{
}

std::string LinearViewObject::valueStr() const
{
    std::ostringstream str;
    str.precision(DOUBLE_FORMAT_PRECISION);
    str << length_;
    return base_.valueStr() + "," + str.str();
}

std::string LinearViewObject::setStr() const
{
    std::ostringstream str;
    str.precision(DOUBLE_FORMAT_PRECISION);
    str << "length=" << length_;
    return base_.setStr() + "," + str.str();
}

const std::string LinearViewObject::tableName = TABLE_OBJECTS_L;
const std::string LinearViewObject::fields = "(id, commit_id, the_geom, zmin, zmax, domain_attrs, length)";
const std::string LinearViewObject::insertFunction = "vrevisions_stable.insert_linear";
const std::string LinearViewObject::updateFunction = "vrevisions_stable.update_linear";
const std::string LinearViewObject::updateSrvAttrsFunction = "vrevisions_stable.update_linear_service_attrs";
const std::string LinearViewObject::deleteFunction = "vrevisions_stable.delete_linear";

} // namespace views
} // namespace wiki
} // namespace maps
