#include "objects_p.h"

#include <maps/wikimap/mapspro/libs/views/include/magic_strings.h>

namespace maps {
namespace wiki {
namespace views {

PointViewObject::PointViewObject(Transaction& work, const GeoObject* obj)
    : base_(work, obj)
{
}

std::string PointViewObject::valueStr() const
{
    return base_.valueStr();
}

std::string PointViewObject::setStr() const
{
    return base_.setStr();
}

const std::string PointViewObject::tableName = TABLE_OBJECTS_P;
const std::string PointViewObject::fields = "(id, commit_id, the_geom, zmin, zmax, domain_attrs)";
const std::string PointViewObject::insertFunction = "vrevisions_stable.insert_point";
const std::string PointViewObject::updateFunction = "vrevisions_stable.update_point";
const std::string PointViewObject::updateSrvAttrsFunction = "vrevisions_stable.update_point_service_attrs";
const std::string PointViewObject::deleteFunction = "vrevisions_stable.delete_point";

} // namespace views
} // namespace wiki
} // namespace maps
