#include "objects_r.h"

#include <maps/wikimap/mapspro/libs/views/include/magic_strings.h>

namespace maps {
namespace wiki {
namespace views {

RelationViewObject::RelationViewObject(Transaction& work, const RelationObject* obj)
    : id_(obj->id())
    , commitId_(obj->revision().commitId())
    , domainAttrs_(obj->attributes().asHstore(work))
    , masterId_(obj->masterId())
    , slaveId_(obj->slaveId())
{
}

std::string RelationViewObject::valueStr() const
{
    std::ostringstream str;
    str << id_ << ","
        << commitId_ << ","
        << domainAttrs_ << ","
        << masterId_ << ","
        << slaveId_;
    return str.str();
}

std::string RelationViewObject::setStr() const
{
    std::ostringstream str;
    str << "commit_id=" << commitId_ << ","
        << "domain_attrs=" << domainAttrs_ << ","
        << "master_id=" << masterId_ << ","
        << "slave_id=" << slaveId_;
    return str.str();
}

const std::string RelationViewObject::tableName = TABLE_OBJECTS_R;
const std::string RelationViewObject::fields = "(id, commit_id, domain_attrs, master_id, slave_id)";
const std::string RelationViewObject::insertFunction = "vrevisions_stable.insert_relation";
const std::string RelationViewObject::updateFunction = "vrevisions_stable.update_relation";
const std::string RelationViewObject::deleteFunction = "vrevisions_stable.delete_relation";

} // namespace views
} // namespace wiki
} // namespace maps
