#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <vector>

namespace maps {
namespace wiki {
namespace views {

class ViewObject
{
public:
    explicit ViewObject(const pqxx::row& dbtuple);
    explicit ViewObject(const ObjectPtr& revisionsObject);
    ViewObject(
        const TRevisionId& revisionId,
        const StringMap& domainAttrs,
        const StringMap& serviceAttrs,
        const Geom& geom);

    TOid id() const { return revisionId_.objectId(); }
    std::string categoryId() const;
    const TRevisionId& revision() const { return revisionId_; }
    const StringMap& domainAttrs() const { return domainAttrs_; }
    const StringMap& serviceAttrs() const { return serviceAttrs_; }
    const std::string& screenLabel() const;
    const std::string& renderLabel() const;
    const Geom& geom() const { return geom_; }

private:
    TRevisionId revisionId_;
    StringMap domainAttrs_;
    StringMap serviceAttrs_;
    Geom geom_;
};

typedef std::vector<ViewObject> ViewObjects;

} // namespace views
} // namespace wiki
} // namespace maps
