#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

namespace maps::wiki::gdpr {

class IDbPools
{
public:
    virtual ~IDbPools() = default;

    virtual pgpool3::Pool& core() = 0;
    virtual pgpool3::Pool& social() = 0;
};

class DbPools : public IDbPools
{
public:
    explicit DbPools(
        const common::ExtendedXmlDoc& config,
        const std::string& poolId = {});

    pgpool3::Pool& core() override { return core_.pool(); }
    pgpool3::Pool& social() override { return social_.pool(); }

private:
    common::PoolHolder core_;
    common::PoolHolder social_;
};

} // namespace maps::wiki::gdpr
