#pragma once

#include <string>

namespace maps::wiki::gdpr::sql {

namespace table {

const std::string GDPR_TAKEOUT = "gdpr.takeout";
const std::string REVISION_COMMIT = "revision.commit";

const std::string SOCIAL_COMMENT = "social.comment";
const std::string SOCIAL_COMMIT_EVENT = "social.commit_event";
const std::string SOCIAL_FEEDBACK_EVENT = "social.feedback_event";
const std::string SOCIAL_FEEDBACK_HISTORY = "social.feedback_history";
const std::string SOCIAL_FEEDBACK_TASK_OUTGOING_CLOSED = "social.feedback_task_outgoing_closed";
const std::string SOCIAL_SUBSCRIPTION = "social.subscription";
const std::string SOCIAL_TASK = "social.task";
const std::string SOCIAL_TASK_CLOSED = "social.task_closed";

const std::string SPRAV_TASKS = "sprav.tasks";

const std::string ACL_BAN_RECORD = "ban_record";
const std::string ACL_GROUP_USER = "group_user";
const std::string ACL_POLICY = "policy";
const std::string ACL_USER = "user";

const auto SOCIAL_PROFILE_TABLES = {
    "badge",
    "profile",
    "prompt",
    "skills",
    "userdata",
};

const auto SOCIAL_STATS_TABLES = {
    "cat_group_edits_stat",
    "stats",
};

} // namespace table

namespace column {

const std::string UID = "uid";
const std::string TAKEOUT_ID = "takeout_id";
const std::string REQUEST_ID = "request_id";
const std::string REQUESTED_AT = "requested_at";
const std::string COMPLETED_AT = "completed_at";

} // namespace column

} // namespace maps::wiki::gdpr::sql
