#include <maps/wikimap/mapspro/services/gdpr/src/lib/takeout_data.h>
#include <maps/wikimap/mapspro/services/gdpr/src/lib/sql_strings.h>

namespace maps::wiki::gdpr {

TakeoutData::TakeoutData(const pqxx::row& row)
    : takeoutId(row[sql::column::TAKEOUT_ID].as<TId>())
    , uid(row[sql::column::UID].as<TUid>())
    , requestId(row[sql::column::REQUEST_ID].as<std::string>())
    , requestTime(chrono::parseSqlDateTime(row[sql::column::REQUESTED_AT].c_str()))
{
    const auto& completedAt = row[sql::column::COMPLETED_AT];
    if (!completedAt.is_null()) {
        completedTime = chrono::parseSqlDateTime(completedAt.c_str());
    }
}

} // namespace maps::wiki::gdpr
