#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/gdpr/src/lib/common.h>
#include <maps/wikimap/mapspro/services/gdpr/src/lib/takeout_data.h>
#include <maps/wikimap/mapspro/services/gdpr/src/lib/takeout_state.h>

#include <chrono>
#include <map>
#include <vector>
#include <optional>
#include <pqxx/pqxx>

namespace maps::wiki::gdpr {

namespace impl {

bool hasEdits(
    pqxx::transaction_base& txnCore,
    TUid uid);

bool hasSocialEvents(
    pqxx::transaction_base& txnSocial,
    TUid uid);

bool hasSocialComments(
    pqxx::transaction_base& txnSocial,
    TUid uid);

bool hasSocialFeedbackEvents(
    pqxx::transaction_base& txnSocial,
    TUid uid);

bool hasSocialFeedbackHistory(
    pqxx::transaction_base& txnSocial,
    TUid uid);

bool hasSocialFeedbackTasks(
    pqxx::transaction_base& txnSocial,
    TUid uid);

bool hasSocialModerationTasks(
    pqxx::transaction_base& txnSocial,
    TUid uid);

bool hasSpravTasks(
    pqxx::transaction_base& txnSocial,
    TUid uid);

} // namespace impl

std::map<std::string, size_t> getCounts(
    pgpool3::Pool& core,
    pgpool3::Pool& social,
    TUid uid);

TakeoutState currentTakeoutState(
    pgpool3::Pool& core,
    pgpool3::Pool& social,
    TUid uid);

std::optional<TakeoutData> currentTakeoutData(
    pqxx::transaction_base& txnCore,
    TUid uid);

std::vector<TakeoutData> getAllTakeoutData(
    pqxx::transaction_base& txnCore,
    TUid uid);

TakeoutData createTakeoutData(
    pqxx::transaction_base& txnCore,
    TUid uid,
    const std::string& requestId);

std::vector<TakeoutData> getTakeoutDataWithThreshold(
    pqxx::transaction_base& txnCore,
    std::chrono::days threshold);

} // namespace maps::wiki::gdpr
