#pragma once

#include <maps/wikimap/mapspro/services/gdpr/src/lib/common.h>
#include <maps/wikimap/mapspro/services/gdpr/src/lib/dbpools.h>

namespace maps::wiki::gdpr {

class Worker
{
public:
    Worker(IDbPools& dbPools, TUid uid, bool dryRun);

    void start(const std::string& requestId) const;
    void status() const;
    void info() const;
    void anonymizeEdits() const;
    void anonymizeComments() const;
    void anonymizeFeedback() const;
    void anonymizeModeration() const;
    void anonymizeSprav() const;
    void cleanAclProfile() const;
    void cleanSocialProfile() const;
    void cleanStats() const;
    void finish() const;

private:
    void finishTxn(pqxx::transaction_base& txn) const;

    IDbPools& dbPools_;
    TUid uid_;
    bool dryRun_;
};

} // namespace maps::wiki::gdpr
