#include <maps/wikimap/mapspro/services/gdpr/src/lib/utils.h>
#include <maps/wikimap/mapspro/libs/unittest/include/yandex/maps/wiki/unittest/localdb.h>

#include <library/cpp/testing/unittest/registar.h>

namespace maps::wiki::gdpr::tests {

namespace {

const TUid TEST_USER = 111;
const auto TEST_REQUEST_ID = "123";
const auto ZERO_THRESHOLD = std::chrono::days{0};

auto& dbPool()
{
    static maps::wiki::unittest::MapsproDbFixture db;
    return db.pool();
}

} // namespace

Y_UNIT_TEST_SUITE(utils_tests)
{

Y_UNIT_TEST(test_has_data_functions)
{
    auto txn = dbPool().slaveTransaction();

    UNIT_ASSERT_EQUAL(impl::hasEdits(*txn, TEST_USER), false);
    UNIT_ASSERT_EQUAL(impl::hasSocialEvents(*txn, TEST_USER), false);
    UNIT_ASSERT_EQUAL(impl::hasSocialComments(*txn, TEST_USER), false);
    UNIT_ASSERT_EQUAL(impl::hasSocialFeedbackEvents(*txn, TEST_USER), false);
    UNIT_ASSERT_EQUAL(impl::hasSocialFeedbackHistory(*txn, TEST_USER), false);
    UNIT_ASSERT_EQUAL(impl::hasSocialFeedbackTasks(*txn, TEST_USER), false);
    UNIT_ASSERT_EQUAL(impl::hasSocialModerationTasks(*txn, TEST_USER), false);
    UNIT_ASSERT_EQUAL(impl::hasSpravTasks(*txn, TEST_USER), false);
}

Y_UNIT_TEST(test_count_data_functions)
{
    UNIT_ASSERT(getCounts(dbPool(), dbPool(), TEST_USER).empty());
}

Y_UNIT_TEST(test_empty_monitoring)
{
    auto txn = dbPool().slaveTransaction();

    UNIT_ASSERT_EQUAL(getTakeoutDataWithThreshold(*txn, ZERO_THRESHOLD).size(), 0);
}

Y_UNIT_TEST(test_empty_takeout_state)
{
    UNIT_ASSERT_EQUAL(
        currentTakeoutState(dbPool(), dbPool(), TEST_USER),
        TakeoutState::Empty);
    UNIT_ASSERT(getCounts(dbPool(), dbPool(), TEST_USER).empty());
}

Y_UNIT_TEST(test_current_takeout_data)
{
    auto txn = dbPool().slaveTransaction();

    UNIT_ASSERT_EQUAL(
        currentTakeoutData(*txn, TEST_USER).has_value(), false);
}

Y_UNIT_TEST(test_create_takeout_data)
{
    {
        auto txn = dbPool().masterWriteableTransaction();

        auto data = createTakeoutData(*txn, TEST_USER, TEST_REQUEST_ID);
        UNIT_ASSERT_EQUAL(data.requestId, TEST_REQUEST_ID);

        txn->commit();
    }

    UNIT_ASSERT_EQUAL(
        currentTakeoutState(dbPool(), dbPool(), TEST_USER),
        TakeoutState::DeleteInProgress);
    UNIT_ASSERT(getCounts(dbPool(), dbPool(), TEST_USER).empty());

    {
        auto txn = dbPool().slaveTransaction();

        UNIT_ASSERT_EQUAL(getTakeoutDataWithThreshold(*txn, ZERO_THRESHOLD).size(), 1);
    }

    {
        auto txn = dbPool().masterWriteableTransaction();

        UNIT_ASSERT_EXCEPTION(
            createTakeoutData(*txn, TEST_USER, TEST_REQUEST_ID).requestId,
            pqxx::pqxx_exception); // user with non-closed takeout request
    }
}

} // utils_tests suite

} // namespace maps::wiki::gdpr::tests
