#include <maps/wikimap/mapspro/services/gdpr/src/lib/worker.h>
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/unittest/include/yandex/maps/wiki/unittest/localdb.h>

#include <library/cpp/testing/unittest/registar.h>

namespace maps::wiki::gdpr::tests {

namespace {

const TUid TEST_USER = 111;
const auto TEST_REQUEST_ID = "123";

class TestDbPools : public IDbPools
{
public:
    TestDbPools() = default;

    pgpool3::Pool& core() override { return db_.pool(); }
    pgpool3::Pool& social() override { return db_.pool(); }

private:
    maps::wiki::unittest::MapsproDbFixture db_;
};

void prepareAcl(auto& pool)
{
    auto txn = pool.masterWriteableTransaction();
    acl::ACLGateway aclGw(*txn);
    auto user = aclGw.createUser(TEST_USER, "test-login", "test display name", TEST_USER);
    for (auto group : {"nmaps", "mpro", "nmaps-novice"}) {
        aclGw.createGroup(group, group);
    }
    aclGw.group("nmaps").add(user);
    aclGw.group("mpro").add(user);
    txn->commit();
}

} // namespace

Y_UNIT_TEST_SUITE(worker_tests)
{

Y_UNIT_TEST(test_worker)
{
    TestDbPools dbPools;
    prepareAcl(dbPools.core());

    for (bool dryRun : { true, false }) {
        Worker worker(dbPools, TEST_USER, dryRun);

        // API
        UNIT_ASSERT_NO_EXCEPTION(worker.status());
        UNIT_ASSERT_NO_EXCEPTION(worker.start(TEST_REQUEST_ID));
        UNIT_ASSERT_NO_EXCEPTION(worker.status());

        // TOOL
        UNIT_ASSERT_NO_EXCEPTION(worker.info());
        UNIT_ASSERT_NO_EXCEPTION(worker.anonymizeEdits());
        UNIT_ASSERT_NO_EXCEPTION(worker.anonymizeComments());
        UNIT_ASSERT_NO_EXCEPTION(worker.anonymizeFeedback());
        UNIT_ASSERT_NO_EXCEPTION(worker.anonymizeModeration());
        UNIT_ASSERT_NO_EXCEPTION(worker.anonymizeSprav());
        UNIT_ASSERT_NO_EXCEPTION(worker.cleanAclProfile());
        UNIT_ASSERT_NO_EXCEPTION(worker.cleanSocialProfile());
        UNIT_ASSERT_NO_EXCEPTION(worker.cleanStats());
        UNIT_ASSERT_NO_EXCEPTION(worker.finish());
    }
}

} // worker_tests suite

} // namespace maps::wiki::gdpr::tests
