// -*- mode: c++ -*-
#pragma once

#include <cstdint>
#include <string>
#include <unordered_map>

namespace maps {
namespace wiki {
namespace tasks_gateway {

using UserId = std::int64_t;
using TaskId = std::int64_t;
using Params = std::unordered_map<std::string, std::string>;

TaskId createTask(const std::string& serviceUrl,
                  const std::string& taskType,
                  UserId userId,
                  const Params& extraParams);

} // namespace tasks_gateway
} // namespace wiki
} // namespace maps
