#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <yandex/maps/mrc/signal_queue/result_queue.h>
#include <yandex/maps/mrc/signal_queue/results.h>

namespace {

constexpr size_t WARN_QUEUE_SIZE{10000};
constexpr size_t ERROR_QUEUE_SIZE{2 * WARN_QUEUE_SIZE};

const std::string QUEUE_TYPE_IMAGES = "images";
const std::string QUEUE_TYPE_RIDES = "rides";

} // anonymous namespace

int main(int argc, char* argv[]) try {
    auto cfg = maps::mrc::common::templateConfig();
    maps::log8::setLevel(maps::log8::Level::FATAL);

    maps::cmdline::Parser parser("Signals uploader queue checker.");
    auto queueType = parser.string("queue-type")
        .help("[images|rides]")
        .required();
    parser.parse(argc, argv);

    maps::mrc::signal_queue::ResultsQueue queue(cfg.signalsUploader().queuePath());
    size_t size = 0;
    if (queueType == QUEUE_TYPE_IMAGES) {
        size = queue.count<maps::mrc::signal_queue::AssignmentImage>();
    } else if (queueType == QUEUE_TYPE_RIDES) {
        size = queue.count<maps::mrc::signal_queue::RideImage>();
    } else {
        std::cout << "2;Error: invalid queue type: " << queueType;
        return EXIT_SUCCESS;
    }

    if (size > ERROR_QUEUE_SIZE) {
        std::cout << "2;Error: queue size is " << size << std::endl;
    }
    else if (size > WARN_QUEUE_SIZE) {
        std::cout << "1;Warning: queue size is " << size << std::endl;
    }
    else {
        std::cout << "0;Ok: queue size is " << size << std::endl;
    }
    return EXIT_SUCCESS;
}
catch (const std::exception& e) {
    std::cout << "2;Error: " << e.what() << std::endl;
    return EXIT_SUCCESS;
}
catch (...) {
    std::cout << "2;Error: unknown exception" << std::endl;
    return EXIT_SUCCESS;
}
