#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/ugc_event_logger/include/logger.h>

#include <yandex/maps/mrc/signal_queue/result_queue.h>
#include <yandex/maps/mrc/signal_queue/results.h>

#include <opencv2/opencv.hpp>

#include <cstdint>
#include <functional>
#include <string>
#include <vector>
#include <variant>

namespace maps::mrc::uploader {

class ResultHandler {
public:
    ResultHandler(const mrc::common::Config& cfg, ugc_event_logger::Logger& ugcEventLogger);

    /**
     * - pop results from all non-empty queues (specified by their result
     *   types in the template parameters).
     */
    template <typename... Ts>
    std::vector<std::variant<Ts...>> pop();

    /**
     * - classify images and save to MDS and MRC DB
     * - push back to local queue if failed
     */
    template<typename T>
    void process(T result);

private:
    db::Feature makeFeature(
            const signal_queue::sresults::Image& resultImage,
            const std::string& sourceId,
            db::Dataset dataset);

    void saveToDatabase(signal_queue::RideImage& result);
    void saveToDatabase(signal_queue::AssignmentImage& result);

    wiki::common::PoolHolder poolHolder_;
    mds::Mds mds_;
    signal_queue::ResultsQueue resultsQueue_;
    ugc_event_logger::Logger& ugcEventLogger_;
};

} //namespace maps::mrc::uploader
