#pragma once

#include "wiki_editor_client.h"

#include <library/cpp/geobase/lookup.hpp>
#include <maps/libs/geolib/include/static_geometry_searcher.h>
#include <maps/libs/road_graph/include/graph.h>
#include <maps/libs/succinct_rtree/include/rtree.h>
#include <maps/wikimap/mapspro/services/mrc/agent-proxy/yacare_servant/lib/suncalc.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/read.h>
#include <maps/wikimap/mapspro/services/mrc/libs/ugc_event_logger/include/logger.h>
#include <yandex/maps/mrc/signal_queue/result_queue.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <memory>

namespace maps::mrc::agent_proxy {

class Globals;
using GlobalsHolder = std::unique_ptr<Globals>;

class Globals {
public:
    static void initialize(
        const common::Config& config,
        const road_graph::Graph& roadGraph,
        const succinct_rtree::Rtree& roadGraphRTree,
        const fb::GraphReader& graphCoverage,
        const NGeobase::TLookup& geobaseLookup,
        ugc_event_logger::Logger& ugcEventLogger,
        IWikiEditorClient& wikiEditorClient,
        ISuncalcPtr);

    static Globals& instance();

    static pgpool3::Pool& pool();
    static mds::Mds& mdsClient();
    static mrc::signal_queue::ResultsQueue& resultsQueue();
    static const road_graph::Graph& roadGraph();
    static const succinct_rtree::Rtree& roadGraphRTree();
    static const fb::GraphReader& graphCoverage();
    static const NGeobase::TLookup& geobaseLookup();
    static ugc_event_logger::Logger& ugcEventLogger();
    static IWikiEditorClient& wikiEditorClient();
    static const ISuncalc& suncalc();

private:
    mrc::signal_queue::ResultsQueue resultsQueue_;
    wiki::common::PoolHolder poolHolder_;
    mds::Mds mdsClient_;
    const road_graph::Graph& roadGraph_;
    const succinct_rtree::Rtree& roadGraphRTree_;
    const fb::GraphReader& graphCoverage_;
    const NGeobase::TLookup& geobaseLookup_;
    ugc_event_logger::Logger& ugcEventLogger_;
    IWikiEditorClient& wikiEditorClient_;
    ISuncalcPtr suncalcPtr_;

private:
    Globals(const common::Config& config,
        const road_graph::Graph& roadGraph,
        const succinct_rtree::Rtree& roadGraphRTree,
        const fb::GraphReader& graphCoverage,
        const NGeobase::TLookup& geobaseLookup,
        ugc_event_logger::Logger& ugcEventLogger,
        IWikiEditorClient& wikiEditorClient,
        ISuncalcPtr);

    static GlobalsHolder& instanceHolder()
    {
        static GlobalsHolder instance_;
        return instance_;
    }

    mds::Mds makeMdsClient(const common::Config& config);
};


} // namespace maps::mrc::agent_proxy
