#include "i18n.h"

#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/i18n/src/include/yandex/maps/i18n/i18n.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/infra/yacare/include/i18n.h>

#include <boost/locale.hpp>

#include <string_view>

namespace maps::mrc::agent_proxy {

namespace {

static const std::string MESSAGES_DOMAIN = "maps-core-nmaps-mrc-agent-proxy";

} //namespace

constexpr maps::enum_io::Representations<I18nToken> I18N_TOKEN_REPRESENTATION {
    {I18nToken::BelarusLawRequireBoundPhone, "belarus_law_require_bound_phone"}
};
DEFINE_ENUM_IO(I18nToken, I18N_TOKEN_REPRESENTATION);

void initLocalization()
{
    static const std::string MESSAGES_PATH
            = "/usr/share/yandex/maps/i18n/messages";
    maps::i18n::addMessagesPath(MESSAGES_PATH);
    maps::i18n::addMessagesDomain(MESSAGES_DOMAIN, {
        maps::Locale{maps::LANG_BE},
        maps::Locale{maps::LANG_EN},
        maps::Locale{maps::LANG_KK},
        maps::Locale{maps::LANG_RU},
        maps::Locale{maps::LANG_TR},
    });
    yacare::setDefaultLang("ru_RU");
}

std::string localizeString(I18nToken token, const std::locale& locale)
{
    std::string text{toString(token)};
    return boost::locale::translate(text).str(locale, MESSAGES_DOMAIN);
}

} // namespace maps::mrc::agent_proxy
