#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_object.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/task.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ride_recording_report.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>

#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/deprecated/localeutils/include/locale.h>

#include <yandex/maps/proto/common2/i18n.sproto.h>
#include <yandex/maps/proto/common2/geo_object.sproto.h>
#include <yandex/maps/proto/common2/geometry.sproto.h>
#include <yandex/maps/proto/common2/metadata.sproto.h>
#include <yandex/maps/proto/common2/response.sproto.h>
#include <yandex/maps/proto/mrc/common/common.sproto.h>
#include <yandex/maps/proto/mrc/ugc/targets.sproto.h>
#include <yandex/maps/proto/mrc/ugc/ugc.sproto.h>
#include <yandex/maps/proto/offline-mrc/results.sproto.h>
#include <yandex/maps/proto/offline_recording/record.pb.h>

namespace pgeo_object = yandex::maps::sproto::common2::geo_object;
namespace pgeometry = yandex::maps::sproto::common2::geometry;
namespace pi18n = yandex::maps::sproto::common2::i18n;
namespace pmetadata = yandex::maps::sproto::common2::metadata;
namespace precord = yandex::maps::proto::offline::recording::record;
namespace presponse = yandex::maps::sproto::common2::response;
namespace presults = yandex::maps::sproto::offline::mrc::results;
namespace ptargets = yandex::maps::sproto::mrc::ugc::targets;
namespace pcommon = yandex::maps::sproto::mrc::common;
namespace pugc = yandex::maps::sproto::mrc::ugc;


namespace maps::mrc::agent_proxy {

pcommon::AssignmentStatus serializeAssignmentStatus(db::ugc::AssignmentStatus status);

pugc::Direction serializeDirection(db::ugc::Direction direction);

pugc::Traffic serializeTraffic(db::ugc::Traffic traffic);

pi18n::Time serializeTime(chrono::TimePoint time, const std::locale& stdLocale);

pcommon::Task serializeTask(
    const db::ugc::Task& task,
    const std::locale& stdLocale);

pcommon::Assignment serializeAssignment(
    const db::ugc::Assignment& assignment,
    const std::locale& stdLocale);

pgeo_object::GeoObject serializeToGeoObject(
    pmetadata::Metadata pbMetadata,
    const db::ugc::Task& task,
    const Locale& locale
);

pgeo_object::GeoObject serializeToGeoObject(
    pmetadata::Metadata pbMetadata,
    const db::ugc::Target& target);

pgeo_object::GeoObject serializeTaskToGeoObject(
    const db::ugc::Task& task,
    const Locale& locale,
    const std::locale& stdLocale);

pgeo_object::GeoObject serializeAssignmentToGeoObject(
    const db::ugc::Assignment& assignment,
    const db::ugc::Task& task,
    const Locale& locale,
    const std::locale& stdLocale);

pgeo_object::GeoObject serializeTargetToGeoObject(
    const db::ugc::Target& target);

pgeo_object::GeoObject serializePolylineToGeoObject(
    const geolib3::Polyline2& polyline);

ptargets::Version serializeCoverageVersion(
    const std::string& version);

db::TrackPoint convertToTrackPoint(
    const std::string& sourceId,
    const presults::TrackPoint& trackPoint);

db::TrackPoint convertToTrackPoint(
    db::TId assignmentId,
    const std::string& sourceId,
    const presults::TrackPoint& trackPoint);

db::TrackPoints extractTrackPoints(
    db::TId assignmentId,
    const std::string& sourceId,
    const presults::Results& data);

db::TrackPoints extractTrackPoints(
    const std::string& sourceId,
    const presults::Results& data);

db::ugc::AssignmentObjectType deserializeAssignmentObjectType(
    presults::ObjectType objectType);

db::ugc::AssignmentObject convertToAssignmentObject(
    db::TId assignmentId,
    const presults::Object& object);

db::ugc::AssignmentObjects extractAssignmentObjects(
    db::TId assignmentId,
    const presults::Results& data);

} //maps::mrc::agent_proxy
