#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/suncalc.h>

#include <memory>

namespace maps::mrc::agent_proxy {

struct ISuncalc {
    virtual ~ISuncalc() = default;
    virtual common::DayPart getDayPart(const geolib3::Point2& geodeticPos,
                                       chrono::TimePoint) const = 0;
};

using ISuncalcPtr = std::shared_ptr<ISuncalc>;

struct Suncalc : ISuncalc {
    common::DayPart getDayPart(const geolib3::Point2& geodeticPos,
                               chrono::TimePoint timePoint) const override
    {
        return common::getDayPart(timePoint, geodeticPos.y(), geodeticPos.x());
    }
};

struct AlwaysDay : ISuncalc {
    common::DayPart getDayPart(const geolib3::Point2&,
                               chrono::TimePoint) const override
    {
        return common::DayPart::Day;
    }
};

}  // namespace maps::mrc::agent_proxy
