#include "wiki_editor_client.h"

namespace maps::mrc::agent_proxy {

using WikiEditorObject = wiki::editor_client::BasicEditorObject;

namespace {

const wiki::revision::UserID ROBOT_UID = 1523901488; // robot-maps-core-mrc

const std::string ATTR_PREFIX = "mrc_pedestrian_region:";
const std::string ATTR_PEDESTRIAN_LOGIN = ATTR_PREFIX + "pedestrian_login";
const std::string ATTR_STATUS = ATTR_PREFIX + "status";

} // namespace

PedestrianZone::PedestrianZone(WikiEditorObject object)
    : object_(std::move(object))
{
}

wiki::revision::DBID PedestrianZone::objectId() const
{
    return object_.id;
}

std::string PedestrianZone::category() const
{
    return object_.categoryId;
}

std::string PedestrianZone::assigneeLogin() const
{
    return getAttr(ATTR_PEDESTRIAN_LOGIN);
}

std::string PedestrianZone::status() const
{
    return getAttr(ATTR_STATUS);
}

void PedestrianZone::setStatus(std::string status)
{
    object_.plainAttributes[ATTR_STATUS] = std::move(status);
}

std::string PedestrianZone::getAttr(const std::string& attr) const
{
    auto itr = object_.plainAttributes.find(attr);
    return itr != object_.plainAttributes.end() ? itr->second : std::string{};
}

WikiEditorClient::WikiEditorClient(std::string urlBase)
    : instance_(urlBase, ROBOT_UID)
{}

PedestrianZone WikiEditorClient::getPedestrianZone(
    wiki::revision::DBID objectId) const
{
    return instance_.getObjectById(objectId);
}

PedestrianZone WikiEditorClient::savePedestrianZone(const PedestrianZone& zone)
{
    return instance_.saveObject(zone.object_);
}

} //maps::mrc::agent_proxy
