#pragma once

#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>
#include <maps/wikimap/mapspro/libs/editor_client/include/instance.h>

namespace maps::mrc::agent_proxy {

using WikiEditorObject = wiki::editor_client::BasicEditorObject;

class PedestrianZone {
public:
    /*implicit*/ PedestrianZone(WikiEditorObject object);

    wiki::revision::DBID objectId() const;

    std::string category() const;

    std::string assigneeLogin() const;

    std::string status() const;

    void setStatus(std::string status);

private:
    std::string getAttr(const std::string& attr) const;

    WikiEditorObject object_;

    friend class WikiEditorClient;
};


class IWikiEditorClient {
public:
    virtual PedestrianZone getPedestrianZone(
        wiki::revision::DBID objectId) const = 0;

    virtual PedestrianZone savePedestrianZone(
        const PedestrianZone& object) = 0;
};


class WikiEditorClient : public IWikiEditorClient {
public:
    WikiEditorClient(std::string urlBase);

    PedestrianZone getPedestrianZone(
        wiki::revision::DBID objectId) const override;

    PedestrianZone savePedestrianZone(
        const PedestrianZone& zone) override;

private:
    wiki::editor_client::Instance instance_;
};

} //maps::mrc::agent_proxy
