#pragma once


#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/libs/http/include/test_utils.h>

#include <string>
#include <string_view>

using namespace std::literals;

namespace maps::mrc::agent_proxy::tests {

constexpr int HTTP_STATUS_OK = 200;
constexpr int HTTP_STATUS_BAD_REQUEST = 400;
constexpr int HTTP_STATUS_UNAUTHORIZED = 401;
constexpr int HTTP_STATUS_NOT_FOUND = 404;
constexpr int HTTP_STATUS_CONFLICT = 409;
constexpr int HTTP_STATUS_SERVER_ERROR = 500;

/// according to https://lite.ip2location.com/belarus-ip-address-ranges
const std::string BELARUS_IP = "37.212.1.1";
const std::string DEFAULT_BELARUS_UPLOAD_DECLINE_DESCRIPTION =
    "Чтобы опубликовать запись, нужно привязать к аккаунту номер телефона. Этого требует законодательство Республики Беларусь.";
const std::string SOURCE_ID = "Samsung100500";
const std::string USER_ID = "111111111";
const std::string USER_ID_RESTRICTED = "222222222";

const auto CLIENT_RIDE_IDS = std::vector<std::optional<std::string>>{
    std::nullopt,
    "b0c2d8c8-6fc6-45d0-9e8e-45e37bd29636",
};

inline void setClientHostPort(http::MockRequest& request, const std::string& host, uint16_t port)
{
    request.headers.emplace("X_FORWARDED_FOR_Y", host);
    request.headers.emplace("X_SOURCE_PORT_Y", std::to_string(port));
}

inline auto addBlackboxMock(std::string_view url)
{
    return http::addMock(
        url,
        [](const http::MockRequest&) {
            return http::MockResponse::fromArcadia("maps/libs/auth/tests/responses/oauth.good");
        });
}

inline std::string makeMdsUrl(const common::Config& config) {
    const auto& mdsConfiguration = config.makeMdsConfiguration();
    return "http://"s + mdsConfiguration.writeHost() + ":"s + std::to_string(mdsConfiguration.writePort()) + "/"s;
}

inline std::string makeMdsUploadUrl(const common::Config& config, const std::string& path)
{
    return makeMdsUrl(config) + "upload-maps_mrc/" + path;
}

} // maps::mrc::agent_proxy::tests
