#pragma once

#include <maps/renderer/libs/design/include/designs.h>
#include <maps/renderer/libs/style2_renderer/include/render_params.h>

#include <filesystem>
#include <memory>
#include <optional>
#include <shared_mutex>
#include <string>

namespace maps::mrc::browser {

class DesignRegistry {
public:
    DesignRegistry(const std::string& designIconsPath,
                   const std::string& designPath);

    std::shared_ptr<renderer::image::ImageStorage> imageStorage() const;

    renderer::design::Design design(
        const std::string& layer,
        const std::optional<std::string>& designExperimentId) const;

    void reloadDesign();

    bool areCartographDesignsLoaded() const;

private:
    const std::filesystem::path designPath_;
    mutable std::shared_mutex designMutex_;

    std::shared_ptr<renderer::image::ImageStorage> imageStorage_;

    std::unordered_map<std::string, renderer::design::Designs> designsFromDataset_; // cartograph
    std::unordered_map<std::string, renderer::design::Design> designsFromResources_; // arcadia
};

} // namespace maps::mrc::browser
