#include "error_reporter.h"
#include "data_access.h"
#include <maps/libs/sql_chemistry/include/exceptions.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/renderer/libs/api_params/include/exception.h>

namespace maps::mrc::browser {

void errorReporter(const yacare::Request&, yacare::Response& resp)
{
    try {
        throw;
    }
    catch (const maps::renderer::api_params::BadRequest& e) {
        resp << (yacare::errors::BadRequest() << e.what());
    }
    catch (const yacare::Error& e) {
        resp.setStatus(yacare::HTTPStatus::find(e.status()));
        resp << e.what();
        ERROR() << e;
    }
    catch (const maps::sql_chemistry::ObjectNotFound& e) {
        resp.setStatus(yacare::HTTPStatus::NotFound);
        resp << e.what();
        ERROR() << e;
    }
    catch (const FbObjectNotFoundException& e) {
        resp.setStatus(yacare::HTTPStatus::NotFound);
        resp << e.what();
        ERROR() << e;
    }
    catch (const maps::Exception& e) {
        resp.setStatus(yacare::HTTPStatus::InternalError);
        resp << e.what();
        ERROR() << e;
    }
    catch (const std::exception& e) {
        resp.setStatus(yacare::HTTPStatus::InternalError);
        resp << e.what();
        ERROR() << "Internal error: " << e.what();
    }
}

} //maps::mrc::browser

