#pragma once

#include "data_access.h"

#include <maps/libs/json/include/builder.h>
#include <maps/wikimap/mapspro/services/mrc/libs/blackbox_client/include/blackbox_client.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>

#include <unordered_map>

namespace maps::mrc::browser {

extern const blackbox_client::UserInfo YANDEX_USER_INFO;

using FeatureIdToUserInfo = std::unordered_map<db::TId, blackbox_client::UserInfo>;

blackbox_client::UserInfo getBlackboxUserInfo(const db::Feature& feature);

FeatureIdToUserInfo getBlackboxUserInfos(const db::Features& features);

void toFeatureAuthorJson(
    const json::ObjectBuilder& builder,
    const blackbox_client::UserInfo& userInfo);

void toFeatureAuthorJson(
    const json::ObjectBuilder& builder,
    db::TId featureId,
    const FeatureIdToUserInfo& featureIdToUserInfo);

auth::DisplayName getDisplayName(const blackbox_client::UserInfo&);

std::string getAvatarUrl(std::string_view avatarId, std::string_view sizeName);

} // namespace maps::mrc::browser
